import { API_ENDPOINTS } from "@/lib/apiEndpoints";
import { Metadata } from "next";
import SubjectDetailsClient from "./SubjectDetailsClient";
import { buildCourseMeta } from "@/lib/seo/projectMeta";

export const dynamic = "force-dynamic";

async function fetchCourseData(code: string) {
    try {
        const res = await API_ENDPOINTS.PROJECTS.COURSE_DETAIL(code);
        if (!res.ok) throw new Error(`HTTP ${res.status}`);
        const data = await res.json();
        return {
            course: data.course,
            list: data.list || []
        };
    } catch (err) {
        console.error("❌ Failed to load course details", err);
        return null;
    }
}

export async function generateMetadata({ params }: { params: Promise<{ code: string }> }): Promise<Metadata> {
    const resolvedParams = await params;
    const data = await fetchCourseData(resolvedParams.code);
    if (!data || !data.course) return { title: "Course Projects" };

    return buildCourseMeta(data.course);
}

export default async function SubjectDetails({ params }: { params: Promise<{ code: string }> }) {
    const resolvedParams = await params;
    const data = await fetchCourseData(resolvedParams.code);

    if (!data) {
        return <div className="text-danger text-center py-5">Failed to load course details.</div>;
    }

    return (
        <SubjectDetailsClient
            courseData={data.course}
            projectsList={data.list}
            courseCode={resolvedParams.code}
        />
    );
}